/*
 * Decompiled with CFR 0.152.
 */
package cottage.machine;

import jef.cpuboard.BasicCpuBoard;
import jef.cpuboard.CpuBoard;
import jef.cpuboard.FastCpuBoard;
import jef.machine.BasicMachine;
import jef.machine.Machine;
import jef.map.InterruptHandler;
import jef.map.ReadHandler;
import jef.map.VoidFunction;
import jef.map.WriteHandler;

public class Pacman
extends BasicMachine
implements Machine {
    public static boolean irqEnabled = false;
    public int readOffset = 98304;
    public static boolean fastBoard = true;

    public InterruptHandler pacman_nmi_interrupt(Pacman m) {
        return new Pacman_NMI_interrupt(m);
    }

    public InterruptHandler pacman_interrupt(Pacman m) {
        return new Pacman_interrupt(m);
    }

    public WriteHandler interrupt_enable_w(Pacman m) {
        return new Interrupt_enable_w(m);
    }

    public WriteHandler interrupt_vector_w(Pacman m) {
        return new Interrupt_vector_w(m);
    }

    public ReadHandler theglob_decrypt_rom(Pacman m) {
        return new Theglob_decrypt_rom(m);
    }

    public ReadHandler MRA_BANK1(Pacman m, int[] mem) {
        return new mra_bank1(m, mem);
    }

    public VoidFunction theglob_init_machine(Pacman m, int[] mem) {
        return new init(m, mem);
    }

    public WriteHandler hiscore(int[] mem, WriteHandler wh) {
        return new HiScore(mem, wh);
    }

    public CpuBoard createCpuBoard(int id) {
        if (fastBoard) {
            return new FastCpuBoard();
        }
        return new BasicCpuBoard();
    }

    public void theglob_decrypt_rom_8(int[] RAM) {
        int mem = 0;
        while (mem < 16384) {
            int oldbyte = RAM[mem];
            int inverted_oldbyte = ~oldbyte;
            int newbyte = 0;
            newbyte = (inverted_oldbyte & 4) >> 1;
            newbyte |= (inverted_oldbyte & 0x20) >> 5;
            newbyte |= (oldbyte & 1) << 5;
            newbyte |= (oldbyte & 2) << 1;
            newbyte |= (inverted_oldbyte & 8) << 4;
            newbyte |= (inverted_oldbyte & 0x10) >> 1;
            newbyte |= (inverted_oldbyte & 0x40) >> 2;
            RAM[mem + 65536] = newbyte |= (inverted_oldbyte & 0x80) >> 1;
            ++mem;
        }
    }

    public void theglob_decrypt_rom_9(int[] RAM) {
        int mem = 0;
        while (mem < 16384) {
            int oldbyte = RAM[mem];
            int inverted_oldbyte = ~oldbyte;
            int newbyte = 0;
            newbyte = (inverted_oldbyte & 4) >> 1;
            newbyte |= (inverted_oldbyte & 0x20) >> 5;
            newbyte |= (oldbyte & 1) << 5;
            newbyte |= (inverted_oldbyte & 2) << 6;
            newbyte |= (oldbyte & 8) << 1;
            newbyte |= (inverted_oldbyte & 0x10) >> 1;
            newbyte |= (inverted_oldbyte & 0x40) >> 4;
            RAM[mem + 81920] = newbyte |= (inverted_oldbyte & 0x80) >> 1;
            ++mem;
        }
    }

    public void theglob_decrypt_rom_A(int[] RAM) {
        int mem = 0;
        while (mem < 16384) {
            int oldbyte = RAM[mem];
            int inverted_oldbyte = ~oldbyte;
            int newbyte = 0;
            newbyte = (inverted_oldbyte & 4) >> 1;
            newbyte |= (inverted_oldbyte & 0x20) >> 5;
            newbyte |= (inverted_oldbyte & 1) << 6;
            newbyte |= (oldbyte & 2) << 1;
            newbyte |= (inverted_oldbyte & 8) << 4;
            newbyte |= (inverted_oldbyte & 0x10) << 1;
            newbyte |= (inverted_oldbyte & 0x40) >> 2;
            RAM[mem + 98304] = newbyte |= (oldbyte & 0x80) >> 4;
            ++mem;
        }
    }

    public void theglob_decrypt_rom_B(int[] RAM) {
        int mem = 0;
        while (mem < 16384) {
            int oldbyte = RAM[mem];
            int inverted_oldbyte = ~oldbyte;
            int newbyte = 0;
            newbyte = (inverted_oldbyte & 4) >> 1;
            newbyte |= (inverted_oldbyte & 0x20) >> 5;
            newbyte |= (inverted_oldbyte & 1) << 6;
            newbyte |= (inverted_oldbyte & 2) << 6;
            newbyte |= (oldbyte & 8) << 1;
            newbyte |= (inverted_oldbyte & 0x10) << 1;
            newbyte |= (inverted_oldbyte & 0x40) >> 4;
            RAM[mem + 114688] = newbyte |= (oldbyte & 0x80) >> 4;
            ++mem;
        }
    }

    public class init
    implements VoidFunction {
        Pacman m;
        int[] mem;

        public init(Pacman m, int[] mem) {
            this.m = m;
            this.mem = mem;
        }

        public void exec() {
            System.out.println("Decrypting roms...");
            this.m.theglob_decrypt_rom_8(this.mem);
            this.m.theglob_decrypt_rom_9(this.mem);
            this.m.theglob_decrypt_rom_A(this.mem);
            this.m.theglob_decrypt_rom_B(this.mem);
        }
    }

    public class mra_bank1
    implements ReadHandler {
        Pacman m;
        int[] mem;

        public mra_bank1(Pacman m, int[] mem) {
            this.m = m;
            this.mem = mem;
        }

        public int read(int address) {
            return this.mem[this.m.readOffset + address];
        }
    }

    public class Theglob_decrypt_rom
    implements ReadHandler {
        Pacman m;
        int counter = 10;

        public Theglob_decrypt_rom(Pacman m) {
            this.m = m;
        }

        public int read(int offset) {
            if ((offset & 1) != 0) {
                --this.counter;
                if (this.counter < 0) {
                    this.counter = 15;
                }
            } else {
                this.counter = this.counter + 1 & 0xF;
            }
            switch (this.counter) {
                case 8: {
                    this.m.readOffset = 65536;
                    break;
                }
                case 9: {
                    this.m.readOffset = 81920;
                    break;
                }
                case 10: {
                    this.m.readOffset = 98304;
                    break;
                }
                case 11: {
                    this.m.readOffset = 114688;
                }
            }
            return 0;
        }
    }

    public class Pacman_NMI_interrupt
    implements InterruptHandler {
        Pacman m;

        public Pacman_NMI_interrupt(Pacman m) {
            this.m = m;
        }

        public int irq() {
            if (irqEnabled) {
                return 1;
            }
            return -1;
        }
    }

    public class Pacman_interrupt
    implements InterruptHandler {
        Pacman m;

        public Pacman_interrupt(Pacman m) {
            this.m = m;
        }

        public int irq() {
            if (irqEnabled) {
                return 0;
            }
            return -1;
        }
    }

    public class Interrupt_enable_w
    implements WriteHandler {
        Pacman m;

        public Interrupt_enable_w(Pacman m) {
            this.m = m;
        }

        public void write(int address, int value) {
            irqEnabled = value != 0;
        }
    }

    public class Interrupt_vector_w
    implements WriteHandler {
        Pacman m;

        public Interrupt_vector_w(Pacman m) {
            this.m = m;
        }

        public void write(int address, int value) {
            this.m.cd[0].cpu.setProperty(0, value);
        }
    }

    public class HiScore
    implements WriteHandler {
        private static final int OFFSET_SCORE = 17399;
        private static final int OFFSET_HIGH_SCORE = 17389;
        long counter = 0L;
        private int[] mem;
        WriteHandler vupdate;

        public HiScore(int[] mem, WriteHandler wh) {
            this.mem = mem;
            this.vupdate = wh;
        }

        public void write(int address, int value) {
            if (this.mem[address] != value) {
                this.mem[address] = value;
                if (this.counter > 250L) {
                    Pacman.this.setHighScore(this.getScore(17389));
                } else {
                    ++this.counter;
                }
                this.vupdate.write(address, value);
            }
        }

        private long getScore(int offset) {
            boolean ZERO_CHAR = false;
            int BLANK_CHAR = 64;
            long score = 0L;
            int i = 0;
            while (i < 7) {
                int c = this.mem[offset + i];
                if (c == 0 || c == 64) {
                    c = 0;
                }
                score = (long)((double)score + (double)(c += 0) * Math.pow(10.0, i));
                ++i;
            }
            if (score > 9999999L) {
                score = 0L;
            }
            return score;
        }
    }
}

